function CDX = set_theta_omega2(CDX, theta_total_avg, omega2, dates)
% --------------------------------------------------------------------------------------------------
% Set theta_Y and fraction of long-run mean that is dues to systematic risk
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure (see 'all_steps_in_a_row.m')
% theta_total_avg   ... theta_Y + Avg(theta_i)
% omega2            ... a_i*theta_Y / (a_i*theta_Y + theta_i)
% dates             ... dates for which to set parameters, if theta_total_avg or omega2 of length > 1
% --------------------------------------------------------------------------------------------------
% sample call: set_omega2(CDX_NA_IG, 0.002, 0.5);
% --------------------------------------------------------------------------------------------------

% Get time series of current theta_Y
% AJD = CDX.AJD_common_factor;
% pos = logical(is_member_sorted_c(dates, CDX.dates{1}));
% if (length(AJD.theta) > 1)
%     theta_Y = AJD.theta(pos);
% else
%     theta_Y = AJD.theta;
% end

% Use fixed (i.e. time-homogenous parameter)
if (nargin == 3)
    % Set value for common factor
    CDX.AJD_common_factor.theta = theta_total_avg * omega2;
    
    % Set value for individual CDS
    for i=1:length(CDX.portfolio)
%         CDX.portfolio(i).AJD.theta = CDX.portfolio(i).ai * theta_Y + ...
%                                      theta_total_avg .* (1-omega2) * CDX.portfolio(i).ai;
        CDX.portfolio(i).AJD.theta = CDX.portfolio(i).ai * theta_total_avg .* (1-omega2);
    end
    return
end

% % Switch from fixed to time-varying parameters (only done once)
% if (length(theta_Y) < length(theta_total_avg)) & (length(dates) > 1)
%     if (length(theta_Y) == 1)
%         theta_Y = repmat(theta_Y, length(theta_total_avg), 1);
%         CDX.AJD_common_factor.theta = repmat(CDX.AJD_common_factor.theta, length(CDX.dates{1}), 1);
%         for i=1:length(CDX.portfolio)
%             cds = CDX.portfolio(i);
%             cds.AJD.theta = repmat(cds.AJD.theta, length(cds.dates{1}), 1);
%             CDX.portfolio(i) = cds;
%         end
%     else
%         error('Parameter dimensions for theta_Y not consistend.');
%     end
% end

% Set value for common factor
[trash, used_pos_cdx, used_pos_params] = intersect_sorted(CDX.dates{1}, dates);
CDX.AJD_common_factor.theta(used_pos_cdx,:) = theta_total_avg(used_pos_params,:) .* omega2(used_pos_params,:);

% Set idiosyncratic theta such that theta_total_avg remains constant
for i=1:length(CDX.portfolio)
    % Determine matching dates
    cds = CDX.portfolio(i);
    [trash, used_pos_cds, used_pos_params] = intersect_sorted(cds.dates{1}, dates);
    if (length(cds.ai) > 1)
        ai = cds.ai(used_pos_cds,:);
    else
        ai = cds.ai;
    end
    % cds.AJD.theta(used_pos_cds,:) = theta_total_avg(used_pos_params,:) .* ai;
    cds.AJD.theta(used_pos_cds,:) = theta_total_avg(used_pos_params,:) .* ai .* (1 - omega2(used_pos_params,:));
    CDX.portfolio(i) = cds;
    clear trash used_pos_cds used_pos_params
end

